#include <stdio.h>
#include <stdlib.h>

#define DL for (d=0;d<3;d++) /* Dimension loop */
#define BF 1e30

/* Positions */
/* Returns number of particles read */
int posread(char *posfile, float ***p, float fact) {

  FILE *pos;
  int np,dum,d,i;
  float xmin,xmax,ymin,ymax,zmin,zmax;

  pos = fopen(posfile, "r");
  if (pos == NULL) {
    printf("Unable to open position file %s\n\n",posfile);
    exit(0);
  }
  /* Fortran77 4-byte headers and footers */
  /* Delete "dum" statements if you don't need them */

  /* Read number of particles */
  fread(&dum,1,4,pos); fread(&np,1, sizeof(int),pos); fread(&dum,1,4,pos);

  /* Allocate the arrays */
  (*p) = (float **)malloc(3*sizeof(float*));
  DL (*p)[d] = (float *)malloc(np*sizeof(float));

  /* Fill the arrays */
  fread(&dum,1,4,pos); fread((*p)[0],np,4,pos); fread(&dum,1,4,pos);
  fread(&dum,1,4,pos); fread((*p)[1],np,4,pos); fread(&dum,1,4,pos);
  fread(&dum,1,4,pos); fread((*p)[2],np,4,pos); fread(&dum,1,4,pos);

  fclose(pos);

  /* Get into physical units (Mpc/h) */
  
  for (i=0; i<np; i++) DL (*p)[d][i] *= fact;

  /* Test range -- can comment out */
  xmin = BF; xmax = -BF; ymin = BF; ymax = -BF; zmin = BF; zmax = -BF;
  for (i=0; i<np;i++) {
    if ((*p)[0][i]<xmin) xmin = (*p)[0][i]; if ((*p)[0][i]>xmax) xmax = (*p)[0][i];
    if ((*p)[1][i]<ymin) ymin = (*p)[1][i]; if ((*p)[1][i]>ymax) ymax = (*p)[1][i];
    if ((*p)[2][i]<zmin) zmin = (*p)[2][i]; if ((*p)[2][i]>zmax) zmax = (*p)[2][i];
  }
  printf("x: %f,%f; y: %f,%f; z: %f,%f\n",xmin,xmax, ymin,ymax, zmin,zmax); fflush(stdout);
  
  return(np);
}

/* Velocities */
/* Returns number of particles read */
int velread(char *velfile, float ***v, float fact) {

  FILE *vel;
  int np,dum,d,i;
  float xmin,xmax,ymin,ymax,zmin,zmax;

  vel = fopen(velfile, "r");
  if (vel == NULL) {
    printf("Unable to open velocity file %s\n\n",velfile);
    exit(0);
  }
  /* Fortran77 4-byte headers and footers */
  /* Delete "dum" statements if you don't need them */

  /* Read number of particles */
  fread(&dum,1,4,vel); fread(&np,1, sizeof(int),vel); fread(&dum,1,4,vel);

  /* Allocate the arrays */
  (*v) = (float **)malloc(3*sizeof(float*));
  for (i=0;i<3;i++) (*v)[i] = (float *)malloc(np*sizeof(float));

  /* Fill the arrays */
  fread(&dum,1,4,vel); fread((*v)[0],np,4,vel); fread(&dum,1,4,vel);
  fread(&dum,1,4,vel); fread((*v)[1],np,4,vel); fread(&dum,1,4,vel);
  fread(&dum,1,4,vel); fread((*v)[2],np,4,vel); fread(&dum,1,4,vel);

  fclose(vel);

  /* Convert from code units into physical units (km/sec) */
  
  for (i=0; i<np; i++) DL (*v)[d][i] *= 100.*fact;

  /* Test range -- can comment out */
  xmin = BF; xmax = -BF; ymin = BF; ymax = -BF; zmin = BF; zmax = -BF;
  for (i=0; i<np;i++) {
    if ((*v)[0][i] < xmin) xmin = (*v)[0][i]; if ((*v)[0][i] > xmax) xmax = (*v)[0][i];
    if ((*v)[1][i] < ymin) ymin = (*v)[1][i]; if ((*v)[1][i] > ymax) ymax = (*v)[1][i];
    if ((*v)[2][i] < zmin) zmin = (*v)[2][i]; if ((*v)[2][i] > zmax) zmax = (*v)[2][i];
  }
  printf("vx: %f,%f; vy: %f,%f; vz: %f,%f\n",xmin,xmax, ymin,ymax, zmin,zmax);
  
  return(np);
}
